<?php

namespace App\Modules\HtlCampLock\Application\Index;

use App\Modules\HtlCampLock\Domain\IdHtlCampLock;
use App\Modules\HtlCampLock\Domain\HtlCampLockRepository;
use App\Modules\HtlCampLock\Domain\IndexHtlCampLock;

final class HtlCampLockIndexer
{
    public function __construct(private HtlCampLockRepository $repository)
    {
    }

    public function __invoke(IdHtlCampLock $idHtlCampLock, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlCampLock($idHtlCampLock, $lockInShare));
        return $index;
    }
}
