<?php

namespace App\Modules\HtlCampLock\Application\Find;

use App\Modules\HtlCampLock\Application\HtlCampLockResponse;
use App\Modules\HtlCampLock\Domain\IdHtlCampLock;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FindHtlCampLockQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampLockFinder $inserter)
    {
    }

    public function __invoke(FindHtlCampLockQuery $query): HtlCampLockResponse
    {
        $model = $this->inserter->__invoke(new IdHtlCampLock($query->getId()));
        return new HtlCampLockResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateStart()->value(),
            $model->amount()->value(),
            $model->status()->value(),
            $model->lock()->value(),
            $model->remark()->value(),
            $model->idHtlCampSchedule()->value(),
            $model->idBookingTour()->value(),
        );
    }
}
