<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Update;

use App\Modules\HtlCampBookingPassenger\Application\Index\HtlCampBookingPassengerIndexer;
use App\Modules\HtlCampBookingPassenger\Domain\IdHtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerWeight;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingPassengerUpdater $updater,
        private HtlCampBookingPassengerIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlCampBookingPassengerQuery $query): UpdateHtlCampBookingPassengerResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampBookingPassenger($query->id()), true);
        $index->setWeight(new HtlCampBookingPassengerWeight($query->weight()));
        $index->setStatus(new HtlCampBookingPassengerStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateHtlCampBookingPassengerResponse();
    }
}
