<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Index;

use App\Modules\HtlCampBookingPassenger\Application\HtlCampBookingPassengerResponse;
use App\Modules\HtlCampBookingPassenger\Domain\IdHtlCampBookingPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampBookingPassengerIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlCampBookingPassengerQuery $query): HtlCampBookingPassengerResponse
    {
        $model = $this->inserter->__invoke(new IdHtlCampBookingPassenger($query->getId()));
        return new HtlCampBookingPassengerResponse(
            $model->id()->value(),
            $model->weight()->value(),
            $model->status()->value(),
            $model->idHtlCampBooking()->value(),
            $model->idBookingTourPassenger()->value(),
        );
    }
}
