<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class HtlCampBookingNotExists extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            400,
            ErrorDictionary::ERRORS['INTERNAL']['HTL_CAMP_BOOKING']['HTL_CAMP_BOOKING_EXISTS']['HTL_CAMP_BOOKING_NOT_EXISTS'],
            'Reserva de campamento no existe'
        );
    }
}
