<?php

namespace App\Modules\HtlCampBooking\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateHtlCampBookingQuery implements Query
{
    public function __construct(
        private string $date,
        private string $dateStart,
        private int $amount,
        private int $amountTotal,
        private int $status,
        private int $lock,
        private string $remark,
        private int $idHtlCamp,
        private int $idBookingTour,
    ) {
    }

    public function date(): string
    {
        return $this->date;
    }
    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function amount(): int
    {
        return $this->amount;
    }

    public function amountTotal(): int
    {
        return $this->amountTotal;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function lock(): int
    {
        return $this->lock;
    }

    public function remark(): string
    {
        return $this->remark;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }

    public function idBookingTour(): int
    {
        return $this->idBookingTour;
    }
}
