<?php

namespace App\Modules\HtlBed\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexHtlBed implements StorageCriteria
{

    public function __construct(
        private IdHtlBed $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlBed::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_bed` `htc`
            WHERE `htc`.`Id_HtlBed` = ?
            AND `htc`.`HtlBed_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlBedNotFound();
        }
        return $data[0];
    }
}
