<?php

namespace App\Modules\HtlBed\Application\Create;

use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\HtlBed\Domain\HtlBedName;
use App\Modules\HtlBed\Domain\HtlBedStatus;
use App\Modules\HtlBed\Domain\HtlBedAvailability;
use App\Modules\HtlBed\Domain\HtlBedDescription;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateHtlBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlBedCreator $creator)
    {
    }

    public function __invoke(CreateHtlBedQuery $query): CreateHtlBedResponse
    {
        $model = new HtlBed(
            new IdHtlBed(0),
            new HtlBedName($query->name()),
            new HtlBedDescription($query->description()),
            new HtlBedAvailability($query->availability()),
            new HtlBedStatus($query->status()),
            new IdHtlCamp($query->idHtlCamp()),
        );
        return new CreateHtlBedResponse($this->creator->__invoke($model));
    }
}
