<?php

namespace App\Modules\History\Domain;

use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListCountHistory implements StorageCriteria
{

    public function __construct(
        private DateStart $dateStart,
        private DateEnd $dateEnd,
        private IdHistoryTable $idHistoryTable,
        private IdHistoryReference $idHistoryReference,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $where = '`h`.`Id_HistoryTable` = ?';
        $data = [$this->idHistoryTable->value()];

        if (!($this->idHistoryReference->value() === 0 || $this->idHistoryReference->value() === null)) {
            $where = ' AND `h`.`Id_Reference` = ?';
            $data[] = $this->idHistoryReference->value();
        }

        $where .= ' AND `h`.`History_Date` BETWEEN ? AND ?';
        $data[] = $this->dateStart->value() . ' 00:00:00';
        $data[] = $this->dateEnd->value() . ' 23:59:59';

        return DB::select(
            "SELECT COUNT(`h`.`Id_History`) AS `count`
            FROM `t_history` `h`
            INNER JOIN `t_history_table` `ht` ON `ht`.`Id_HistoryTable` = `h`.`Id_HistoryTable`
            LEFT JOIN `t_admin` `a` ON `a`.`Id_Admin` = `h`.`Id_Admin`
            WHERE $where",
            $data
        );
    }

    protected function analize($data)
    {
        return $data[0]->count;
    }
}
