<?php

namespace App\Modules\History\Domain;


use App\Modules\HistoryTable\Domain\HistoryTableName;
use App\Modules\HistoryTable\Domain\HistoryTableTitle;
use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\Shared\Domain\ValueObject\NullableValueObject;

class HistoryList extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHistory::class, 'Id_History', 'primary'),
            new AggregateAttribute('date', HistoryDate::class, 'History_Date'),
            new AggregateAttribute('valueOld', HistoryValueOld::class, 'History_ValueOld'),
            new AggregateAttribute('valueNew', HistoryValueNew::class, 'History_ValueNew'),
            new AggregateAttribute('operation', HistoryOperation::class, 'History_Operation'),
            new AggregateAttribute('idRecord', IdHistoryRecord::class, 'Id_Record'),
            new AggregateAttribute('idReference', IdHistoryReference::class, 'Id_Reference'),
            new AggregateAttribute('idAdmin', NullableValueObject::class, 'Id_Admin'),
            new AggregateAttribute('adminName', NullableValueObject::class, 'Admin_Name'),
            new AggregateAttribute('adminLastName', NullableValueObject::class, 'Admin_LastName'),
            new AggregateAttribute('adminNoDocument', NullableValueObject::class, 'Admin_NoDocument'),
            new AggregateAttribute('idHistoryTable', IdHistoryTable::class, 'Id_HistoryTable'),
            new AggregateAttribute('historyTableName', HistoryTableName::class, 'HistoryTable_Name'),
            new AggregateAttribute('historyTableTitle', HistoryTableTitle::class, 'HistoryTable_Title'),
        ];
    }

    protected static function table(): string
    {
        return 't_history';
    }

    public function __construct(
        private IdHistory $id,
        private HistoryDate $date,
        private HistoryValueOld $valueOld,
        private HistoryValueNew $valueNew,
        private HistoryOperation $operation,
        private IdHistoryRecord $idRecord,
        private IdHistoryReference $idReference,
        private NullableValueObject $idAdmin,
        private NullableValueObject $adminName,
        private NullableValueObject $adminLastName,
        private NullableValueObject $adminNoDocument,
        private IdHistoryTable $idHistoryTable,
        private HistoryTableName $historyTableName,
        private HistoryTableTitle $historyTableTitle,
    ) {
    }

    public function id(): IdHistory
    {
        return $this->id;
    }

    public function date(): HistoryDate
    {
        return $this->date;
    }

    public function valueOld(): HistoryValueOld
    {
        return $this->valueOld;
    }

    public function valueNew(): HistoryValueNew
    {
        return $this->valueNew;
    }

    public function operation(): HistoryOperation
    {
        return $this->operation;
    }

    public function idRecord(): IdHistoryRecord
    {
        return $this->idRecord;
    }

    public function idReference(): IdHistoryReference
    {
        return $this->idReference;
    }

    public function idAdmin(): NullableValueObject
    {
        return $this->idAdmin;
    }

    public function adminName(): NullableValueObject
    {
        return $this->adminName;
    }

    public function adminLastName(): NullableValueObject
    {
        return $this->adminLastName;
    }

    public function adminNoDocument(): NullableValueObject
    {
        return $this->adminNoDocument;
    }

    public function idHistoryTable(): IdHistoryTable
    {
        return $this->idHistoryTable;
    }

    public function historyTableName(): HistoryTableName
    {
        return $this->historyTableName;
    }

    public function historyTableTitle(): HistoryTableTitle
    {
        return $this->historyTableTitle;
    }
}
