<?php

namespace App\Modules\History\Application\ListCount;

use App\Modules\History\Domain\HistoryRepository;
use App\Modules\History\Domain\IdHistoryReference;
use App\Modules\History\Domain\ListCountHistory;
use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class HistoryListCounter
{
    public function __construct(private HistoryRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        IdHistoryTable $idHistoryTable,
        IdHistoryReference $idHistoryReference,
        string $action
    ) {
        return $this->repository->search(new ListCountHistory(
            $dateStart,
            $dateEnd,
            $idHistoryTable,
            $idHistoryReference,
            $action
        ));
    }
}
