<?php

namespace App\Modules\GroupProviderReview\Application\ListFromGroup;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderReview\Domain\GroupProviderReviewRepository;

final class GroupProviderReviewGroupLister
{
    public function __construct(private GroupProviderReviewRepository $repository)
    {
    }

    public function __invoke(IdGroup $idGroup, string $action): GroupProviderReviewListFromGroupResponse
    {
        return new GroupProviderReviewListFromGroupResponse($this->repository->fromGroup($idGroup, $action));
    }
}
