<?php

namespace App\Modules\GroupProviderReview\Application\Create;

use App\Modules\GroupProviderReview\Application\Create\GroupProviderReviewInserterResponse;
use App\Modules\GroupProviderReview\Domain\GroupProviderReviewRepository;
use App\Modules\GroupProviderReview\Domain\InsertGroupProviderReview;

final class GroupProviderReviewInserter
{
    public function __construct(private GroupProviderReviewRepository $repository)
    {
    }

    public function __invoke(InsertGroupProviderReview $GroupProviderReview): GroupProviderReviewInserterResponse
    {
        return new GroupProviderReviewInserterResponse($this->repository->insert($GroupProviderReview));
    }
}
