<?php

namespace App\Modules\GroupProviderMedia\Application\Delete;

use App\Modules\GroupProviderMedia\Domain\IdGroupProviderMedia;
use App\Modules\GroupProviderMedia\Application\Index\GroupProviderMediaIndexer;
use App\Modules\GroupProviderMedia\Application\Update\GroupProviderMediaUpdater;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaError;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaStatus;
use App\Modules\Media\Application\Delete\DeleteMediaQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteGroupProviderMediaQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupProviderMediaUpdater $update,
        private GroupProviderMediaIndexer $indexer,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(DeleteGroupProviderMediaQuery $query): DeleteGroupProviderMediaResponse
    {
        $index = $this->indexer->__invoke(new IdGroupProviderMedia($query->idGroupProviderMedia()), true);
        $index->delete();
        $this->update->__invoke($index);
        try {
            $this->queryBus->ask(new DeleteMediaQuery($index->path()->value()));
        } catch (\Throwable $th) {
            $index->setError(new GroupProviderMediaError('Error deleting media: ' . $th->getMessage()));
            $index->setStatus(new GroupProviderMediaStatus(GroupProviderMediaStatus::ERROR));
            $this->update->__invoke($index);
        }
        return new DeleteGroupProviderMediaResponse();
    }
}
