<?php

namespace App\Modules\GroupProviderMedia\Application\Create;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderMedia\Domain\IdGroupProviderMedia;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMedia;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaDescription;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaError;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaExtension;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaHasThumbnail;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaPath;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaPathLargeThumb;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaPathThumb;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaSize;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaStatus;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateGroupProviderMediaQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderMediaCreator $creator)
    {
    }

    public function __invoke(CreateGroupProviderMediaQuery $query): CreateGroupProviderMediaResponse
    {
        $model = new GroupProviderMedia(
            new IdGroupProviderMedia(0),
            new GroupProviderMediaPath($query->path()),
            new GroupProviderMediaPathThumb($query->pathThumb()),
            new GroupProviderMediaPathLargeThumb($query->pathLargeThumb()),
            new GroupProviderMediaDescription($query->description()),
            new GroupProviderMediaExtension($query->extension()),
            new GroupProviderMediaSize($query->size()),
            new GroupProviderMediaType($query->type()),
            new GroupProviderMediaHasThumbnail($query->hasThumbnail()),
            new GroupProviderMediaError($query->error()),
            new GroupProviderMediaStatus($query->status()),
            new IdGroupProvider($query->idGroupProvider()),
        );
        return new CreateGroupProviderMediaResponse($this->creator->__invoke($model));
    }
}
