<?php

namespace App\Modules\GroupProvider\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\GroupProvider;
use App\Modules\GroupProvider\Domain\GroupProviderModel;
use App\Modules\GroupProvider\Domain\GroupProviderMask;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Provider\Domain\ProviderNoDocument;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlGroupProviderRepository implements GroupProviderRepository
{


    public function find(StorageCriteria $criteria)
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return $criteria->run();
    }

    public function searchByDocument(IdGroup $idGroup, ProviderNoDocument $noDocument)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_search_by_document(?,?,@sts,@cod,@msg)',
            [
                $idGroup->value(),
                $noDocument->value()
            ]
        );
    }

    public function searchByDocumentOnly(ProviderNoDocument $noDocument)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_search_by_document_only(?,?,@sts,@cod,@msg)',
            [
                // $idGroup->value(),
                $noDocument->value()
            ]
        );
    }

    public function mask(IdGroupProvider $id, GroupProviderMask $mask)
    {
        return Requester::requestUpdate(
            'CALL sp_group_provider_update_mask(?,?,@sts,@cod,@msg)',
            [$id->value(), $mask->value()]
        );
    }

    public function list(IdGroup $idGroup)
    {
        return (new SelectHandler())->handle(DB::select('call sp_group_provider_list(?)', [$idGroup->value()]));
    }

    public function search(StorageCriteria $criteria): array
    {
        return $criteria->run();
    }

    public function updateModel(GroupProvider $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
