<?php

namespace App\Modules\GroupProvider\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

/**
 * @extends StorageCriteria<GroupProvider>
 */
class ListGalleryGroupProvider implements StorageCriteria
{

    private $actionList = [
        'all' => '(2, 3, 4, 5, 6)',
        'downloaded' => '(6)',
        'not_downloaded' => '(2, 3, 4, 5)',
        'pending' => '(1)'
    ];

    public function __construct(
        private DateStart $dateStart,
        private DateEnd $dateEnd,
        private string $search,
        private string $action,
        private QueryPaginate $queryPaginate
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupProvider::select('`gp`');

        $where = '`gp`.`GroupProvider_MediaDateUpdate` BETWEEN ? AND ?';
        $data[] = $this->dateStart->value() . ' 00:00:00';
        $data[] = $this->dateEnd->value() . ' 23:59:59';

        $where .= ' AND `gp`.`GroupProvider_MediaStatus` IN ' . $this->findActionElement($this->action);


        $limit = '';
        if ($this->queryPaginate->isPaginated()) {
            $limit = "LIMIT " . $this->queryPaginate->getOffset() . ", " . $this->queryPaginate->getLimit();
        }
        return DB::select(
            "SELECT `frm_aux`.*,

                    `p`.`Provider_BusinessName`,
                    `p`.`Provider_TradeName`,
                    `p`.`Provider_NickName`,
                    `p`.`Provider_NoDocument`,
                    `p`.`Provider_Address`,
                    `p`.`Provider_Phone`,
                    `p`.`Provider_ImgProfile`,
                    `p`.`Provider_ImgProfile_Thumb`,
                    `p`.`Provider_Score`,
                    `p`.`Provider_ScoreTotal`,
                    `p`.`Provider_NoScored`,
                    `p`.`Provider_ScoreCant`,
                    `p`.`Provider_Status`,
                    `p`.`Id_TypeDocument`,
                    `p`.`Id_Country`,
                    `p`.`Id_State`,
                    `p`.`Id_City`,

                    `tp`.`TypeProvider_Name`,
                    `tp`.`TypeProvider_Abrv`,
                    `tp`.`TypeProvider_Endorser`,
                    `tp`.`TypeProvider_Lock`,
                    `tp`.`TypeProvider_Status`,

                    `g`.`Group_Date`,
                    `g`.`Group_DateUpdate`,
                    `g`.`Group_DateStart`,
                    `g`.`Group_DateEnd`,
                    `g`.`Group_Hour`,
                    `g`.`Group_Name`,
                    `g`.`Group_Token`,
                    `g`.`Group_Origin`,
                    `g`.`Group_Destination`,
                    `g`.`Group_Type`,
                    `g`.`Group_Order`,
                    `g`.`Group_TourDuration`,
                    `g`.`Group_Remark`,
                    `g`.`Group_MasterType`,
                    `g`.`Group_ServiceType`,
                    `g`.`Group_NoValidPassengers`,
                    `g`.`Group_ValidPassengers`,
                    `g`.`Group_Status`,
                    `g`.`Id_Master`,
                    `g`.`Id_Service`,
                    `g`.`Id_StatusGroup`,

                    `t`.`Id_Tour`,
                    `t`.`Tour_Code`,
                    `t`.`Tour_Name`,
                    `t`.`Tour_UrlThumbnail`,
                    `t`.`Tour_Duration`,
                    `t`.`Tour_MinPax`,
                    `t`.`Tour_Availability`,
                    `t`.`Tour_AvailabilityStatus`,
                    `t`.`Tour_Anticipation`,
                    `t`.`Tour_AnticipationType`,
                    `t`.`Tour_Color`,
                    `t`.`Tour_Score`,
                    `t`.`Tour_ScoreCant`,
                    `t`.`Tour_ScoreTotal`,
                    `t`.`Tour_Status`,
                    `t`.`Id_CategoryTour`,
                    `t`.`Id_TypeTour`,
                    `t`.`Id_Country`,
                    `t`.`Id_State`,
                    `t`.`Id_City`
            FROM (
                SELECT $select
                FROM `t_group_provider` `gp`
                WHERE $where
            ) AS `frm_aux`
            INNER JOIN `t_provider` `p` ON `p`.`Id_Provider` = `frm_aux`.`Id_Provider`
            INNER JOIN `t_type_provider` `tp` ON `tp`.`Id_TypeProvider` = `frm_aux`.`Id_TypeProvider`
            INNER JOIN `t_group` `g` ON `g`.`Id_Group` = `frm_aux`.`Id_Group`
            LEFT JOIN `t_tour` `t` ON `t`.`Id_Tour` = `g`.`Id_Service` AND `g`.`Group_ServiceType` IN (1, 2)
            ORDER BY `frm_aux`.`GroupProvider_MediaDateUpdate` DESC",
            $data
        );
    }

    private function findActionElement($action)
    {
        if (array_key_exists($action, $this->actionList)) {
            return $this->actionList[$action];
        }
        return $this->actionList['not_downloaded'];
    }

    protected function analize($data)
    {
        return array_map(fn ($data) => (object)[
            'Id_GroupProvider' => $data->Id_GroupProvider,
            'GroupProvider_Type' => $data->GroupProvider_Type,
            'GroupProvider_Remark' => $data->GroupProvider_Remark,
            'GroupProvider_AnsweredReview' => $data->GroupProvider_AnsweredReview,
            'GroupProvider_Mask' => $data->GroupProvider_Mask,
            'GroupProvider_IsCloned' => $data->GroupProvider_IsCloned,
            'GroupProvider_MediaDateUpdate' => $data->GroupProvider_MediaDateUpdate,
            'GroupProvider_MediaStatus' => $data->GroupProvider_MediaStatus,
            'GroupProvider_MediaScore' => $data->GroupProvider_MediaScore,
            'GroupProvider_MediaScoreDescription' => $data->GroupProvider_MediaScoreDescription,
            'Id_Group' => $data->Id_Group,
            'Id_Provider' => $data->Id_Provider,
            'Id_TypeProvider' => $data->Id_TypeProvider,
            'Id_StatusGroupProvider' => $data->Id_StatusGroupProvider,
            'Provider_BusinessName' => $data->Provider_BusinessName,
            'Provider_TradeName' => $data->Provider_TradeName,
            'Provider_NickName' => $data->Provider_NickName,
            'Provider_NoDocument' => $data->Provider_NoDocument,
            'Provider_Address' => $data->Provider_Address,
            'Provider_Phone' => $data->Provider_Phone,
            'Provider_ImgProfile' => $data->Provider_ImgProfile,
            'Provider_ImgProfile_Thumb' => $data->Provider_ImgProfile_Thumb,
            'Provider_Score' => $data->Provider_Score,
            'Provider_ScoreTotal' => $data->Provider_ScoreTotal,
            'Provider_NoScored' => $data->Provider_NoScored,
            'Provider_ScoreCant' => $data->Provider_ScoreCant,
            'Provider_Status' => $data->Provider_Status,
            'Id_TypeDocument' => $data->Id_TypeDocument,
            'Id_Country' => $data->Id_Country,
            'Id_State' => $data->Id_State,
            'Id_City' => $data->Id_City,
            'TypeProvider_Name' => $data->TypeProvider_Name,
            'TypeProvider_Abrv' => $data->TypeProvider_Abrv,
            'TypeProvider_Endorser' => $data->TypeProvider_Endorser,
            'TypeProvider_Lock' => $data->TypeProvider_Lock,
            'TypeProvider_Status' => $data->TypeProvider_Status,
            'Group_Date' => $data->Group_Date,
            'Group_DateUpdate' => $data->Group_DateUpdate,
            'Group_DateStart' => $data->Group_DateStart,
            'Group_DateEnd' => $data->Group_DateEnd,
            'Group_Hour' => $data->Group_Hour,
            'Group_Name' => $data->Group_Name,
            'Group_Token' => $data->Group_Token,
            'Group_Origin' => $data->Group_Origin,
            'Group_Destination' => $data->Group_Destination,
            'Group_Type' => $data->Group_Type,
            'Group_Order' => $data->Group_Order,
            'Group_TourDuration' => $data->Group_TourDuration,
            'Group_Remark' => $data->Group_Remark,
            'Group_MasterType' => $data->Group_MasterType,
            'Group_ServiceType' => $data->Group_ServiceType,
            'Group_NoValidPassengers' => $data->Group_NoValidPassengers,
            'Group_ValidPassengers' => $data->Group_ValidPassengers,
            'Group_Status' => $data->Group_Status,
            'Id_Master' => $data->Id_Master,
            'Id_Service' => $data->Id_Service,
            'Id_StatusGroup' => $data->Id_StatusGroup,
            'Id_Tour' => $data->Id_Tour,
            'Tour_Code' => $data->Tour_Code,
            'Tour_Name' => $data->Tour_Name,
            'Tour_UrlThumbnail' => $data->Tour_UrlThumbnail,
            'Tour_Duration' => $data->Tour_Duration,
            'Tour_MinPax' => $data->Tour_MinPax,
            'Tour_Availability' => $data->Tour_Availability,
            'Tour_AvailabilityStatus' => $data->Tour_AvailabilityStatus,
            'Tour_Anticipation' => $data->Tour_Anticipation,
            'Tour_AnticipationType' => $data->Tour_AnticipationType,
            'Tour_Color' => $data->Tour_Color,
            'Tour_Score' => $data->Tour_Score,
            'Tour_ScoreCant' => $data->Tour_ScoreCant,
            'Tour_ScoreTotal' => $data->Tour_ScoreTotal,
            'Tour_Status' => $data->Tour_Status,
            'Id_CategoryTour' => $data->Id_CategoryTour,
            'Id_TypeTour' => $data->Id_TypeTour,
            'Id_Country' => $data->Id_Country,
            'Id_State' => $data->Id_State,
            'Id_City' => $data->Id_City
        ], $data);
    }
}
