<?php

namespace App\Modules\GroupProvider\Application\UpdateStatus;

use App\Modules\GroupProvider\Domain\GroupProviderMediaStatus;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateStatusGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(
        private StatusGroupProviderUpdater $reviewer
    ) {
    }

    public function __invoke(UpdateStatusGroupProviderQuery $query): UpdateStatusGroupProviderResponse
    {
        $this->reviewer->__invoke(
            new IdGroupProvider($query->id()),
            new GroupProviderMediaStatus($query->mediaStatus())
        );
        return new UpdateStatusGroupProviderResponse();
    }
}
