<?php

namespace App\Modules\GroupProvider\Application\Report;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReportGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderReporter $update)
    {
    }

    public function __invoke(ReportGroupProviderQuery $query): ReportGroupProviderResponse
    {
        return $this->update->__invoke(
            new GroupDateStart($query->dateStart()),
            new GroupDateEnd($query->dateEnd())
        );
    }
}
