<?php

namespace App\Modules\GroupProvider\Application\Mask;

use App\Modules\GroupProvider\Domain\GroupProviderMask;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\IdGroupProvider;

class GroupProviderMasker
{

    private GroupProviderRepository $repository;

    public function __construct(GroupProviderRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroupProvider $id, GroupProviderMask $mask)
    {
        return new MaskGroupProviderResponse($this->repository->mask($id, $mask));
    }
}
