<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;

interface GroupPassengerRepository
{
    public function find(StorageCriteria $criteria): GroupPassengerModel | null;
    public function index(IdGroupPassenger $id): GroupPassenger;
    public function update(GroupPassenger $model);
    public function findWithReview(IdGroup $idGroup, $path, $pathCountry): array;

    /**
     * @template T
     * @param StorageCriteria<T> $criteria
     * @return array<T>
     */
    public function search(StorageCriteria $criteria);
    public function updateModel(GroupPassengerModel $model);
}
