<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class GroupPassengerFailOnChange extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            404,
            ErrorDictionary::ERRORS['OWNER']['GROUP_PASSENGER']['GROUP_PASSENGER_CHANGE']['GROUP_PASSENGER_FAIL_ON_CHANGE'],
            'Estado de Pasajero de grupo no se puede cambiar'
        );
    }
}
