<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Group\Domain\IdGroup;

final class GroupPassenger
{
    public function __construct(
        private IdGroupPassenger $id,
        private GroupPassengerType $type,
        private GroupPassengerNotification $notification,
        private GroupPassengerNotificationAccepted $notificationAccepted,
        private GroupPassengerExternalReview $externalReview,
        private GroupPassengerReviewStatus $reviewStatus,
        private GroupPassengerReviewDateUpdate $reviewDateUpdate,
        private IdGroup $idGroup,
        private GroupPassengerIdAlter $idAlter,
    ) {
    }

    public function id(): IdGroupPassenger
    {
        return $this->id;
    }

    public function type(): GroupPassengerType
    {
        return $this->type;
    }

    public function notification(): GroupPassengerNotification
    {
        return $this->notification;
    }

    public function notificationAccepted(): GroupPassengerNotificationAccepted
    {
        return $this->notificationAccepted;
    }

    public function externalReview(): GroupPassengerExternalReview
    {
        return $this->externalReview;
    }

    public function reviewStatus(): GroupPassengerReviewStatus
    {
        return $this->reviewStatus;
    }

    public function reviewDateUpdate(): GroupPassengerReviewDateUpdate
    {
        return $this->reviewDateUpdate;
    }

    public function idGroup(): IdGroup
    {
        return $this->idGroup;
    }

    public function idAlter(): GroupPassengerIdAlter
    {
        return $this->idAlter;
    }

    public function setReviewStatus(GroupPassengerReviewStatus $value)
    {
        $this->reviewStatus = $value;
    }

    public function setReviewDateUpdate(GroupPassengerReviewDateUpdate $value)
    {
        $this->reviewDateUpdate = $value;
    }

}
