<?php

namespace App\Modules\GroupPassenger\Application\UpdateMediaScore;

use App\Modules\GroupPassenger\Application\Index\GroupPassengerIndexer;
use App\Modules\GroupPassenger\Domain\GroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerMediaDateUpdate;
use App\Modules\GroupPassenger\Domain\GroupPassengerMediaScore;
use App\Modules\GroupPassenger\Domain\GroupPassengerMediaStatus;
use App\Modules\GroupPassenger\Domain\GroupPassengerModel;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class MediaScoreGroupPassengerUpdater
{
    public function __construct(
        private GroupPassengerRepository $repository,
        private QueryBus $queryBus,
        private GroupPassengerIndexer $groupPassengerIndexer
    ) {
    }

    public function __invoke(IdGroupPassenger $id, GroupPassengerMediaScore $mediaScore)
    {
        /** @var GroupPassengerModel $index */
        $index = $this->groupPassengerIndexer->__invoke($id);
        $index->setMediaStatus(new GroupPassengerMediaStatus(GroupPassengerMediaStatus::SCORED));
        // $index->setMediaDateUpdate(GroupPassengerMediaDateUpdate::reduceDatetimeToPeru(GroupPassengerMediaDateUpdate::now()));
        $index->setMediaScore($mediaScore);
        return $this->repository->updateModel($index);
    }
}
