<?php

namespace App\Modules\GroupPassenger\Application\DeleteMedia;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteMediaGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupPassengerMediaDeleter $deleter
    ) {
    }

    public function __invoke(DeleteMediaGroupPassengerQuery $query): DeleteMediaGroupPassengerResponse
    {
        $response = $this->deleter->__invoke(new IdGroupPassenger($query->id()));
        return new DeleteMediaGroupPassengerResponse($response);
    }
}
