<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\CreateGroup;
use App\Modules\Group\Domain\GroupRepository;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Application\InsertHandler;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlGroupRepository implements GroupRepository
{

    public function insert(CreateGroup $group)
    {
        $response = (new InsertHandler)
            ->handle(DB::select(
                'CALL sp_group_insert(?,?,?,?,?,?,?,?)',
                [
                    $group->dateStart()->value(),
                    $group->hour()->value(),
                    $group->origin()->value(),
                    $group->destination()->value(),
                    $group->type()->value(),
                    $group->remark()->value(),
                    $group->serviceType()->value(),
                    $group->idService()->value(),
                ]
            ));

        return $response[0]->Response_Id;
    }

    public function passengerGroupIndexer(IdGroup $id)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_group_index(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

    public function passengerValidation(IdGroup $idGroup)
    {
        return Requester::requestUpdate(
            'CALL sp_internal_group_passenger_validation(?,@sts,@cod,@msg)',
            [
                $idGroup->getValue(),
            ]
        );
    }

    public function index(IdGroup $idGroup)
    {
        return (new SelectHandler)
            ->handle(DB::select('CALL sp_group_index(?)', [$idGroup->getValue()]));
    }
}
