<?php

namespace App\Modules\Group\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class GroupMasterType extends EnumValueObject
{
    public const INDEPENDENT = 0;
    public const SLAVE = 1;
    public const MASTER = 2;

    public static function defaultValue(): int
    {
        return self::INDEPENDENT;
    }

    public static function values(): array
    {
        return [self::INDEPENDENT, self::SLAVE, self::MASTER];
    }
}
