<?php

namespace App\Modules\Group\Application;

use App\Modules\Group\Domain\GroupRepository;
use App\Modules\Group\Domain\GroupToken;
use App\Modules\Group\Domain\IdGroup;

class PassengerGroupIndexer
{

    private GroupRepository $repository;

    public function __construct(GroupRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(GroupToken $groupToken, GroupTokenFinder $groupTokenFinder)
    {
        $response = $groupTokenFinder->__invoke($groupToken);
        return $this->repository->passengerGroupIndexer(new IdGroup($response[0]->Response_Id));
    }
}
