<?php

namespace App\Modules\Group\Application\ListGroupProgramming;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListGroupProgrammingQuery implements Query
{
    public function __construct(
        private string $action,
        private int $idCategoryTour,
        private int $idTour,
        private string $dateStart,
        private string $dateEnd,
        private string $token
    ) {
    }

    public function action(): string
    {
        return $this->action;
    }
    public function idCategoryTour(): int
    {
        return $this->idCategoryTour;
    }
    public function idTour(): int
    {
        return $this->idTour;
    }
    public function dateStart(): string
    {
        return $this->dateStart;
    }
    public function dateEnd(): string
    {
        return $this->dateEnd;
    }
    public function token(): string
    {
        return $this->token;
    }
}
