<?php

namespace App\Modules\Flight\Domain;

use App\Modules\Booking\Domain\IdBooking;

class Flight
{

    public function __construct(
        private IdFlight $id,
        private FlightDateDeparture $dateDeparture,
        private FlightDateArrival $dateArrival,
        private FlightOrigin $origin,
        private FlightDestination $destination,
        private FlightNumber $number,
        private FlightCarrier $carrier,
        private FlightObservation $observation,
        private FlightType $type,
        private IdBooking $idBooking,
    ) {
    }

    
    public function id(): IdFlight
    {
        return $this->id;
    }

    public function dateDeparture(): FlightDateDeparture
    {
        return $this->dateDeparture;
    }

    public function dateArrival(): FlightDateArrival
    {
        return $this->dateArrival;
    }

    public function origin(): FlightOrigin
    {
        return $this->origin;
    }

    public function destination(): FlightDestination
    {
        return $this->destination;
    }

    public function number(): FlightNumber
    {
        return $this->number;
    }

    public function carrier(): FlightCarrier
    {
        return $this->carrier;
    }

    public function observation(): FlightObservation
    {
        return $this->observation;
    }

    public function type(): FlightType
    {
        return $this->type;
    }

    public function idBooking(): IdBooking
    {
        return $this->idBooking;
    }


}
