<?php

namespace App\Modules\Flight\Application\Insert;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class InsertFlightQuery implements Query
{
    public function __construct(
        private string $dateDeparture,
        private string $dateArrival,
        private string $origin,
        private string $destination,
        private string $number,
        private string $carrier,
        private string $observation,
        private int $type,
        private int $idBooking,
    ) {}

    public function dateDeparture(): string
    {
        return $this->dateDeparture;
    }

    public function dateArrival(): string
    {
        return $this->dateArrival;
    }

    public function origin(): string
    {
        return $this->origin;
    }

    public function destination(): string
    {
        return $this->destination;
    }

    public function number(): string
    {
        return $this->number;
    }

    public function carrier(): string
    {
        return $this->carrier;
    }

    public function observation(): string
    {
        return $this->observation;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function idBooking(): int
    {
        return $this->idBooking;
    }
}
