<?php

namespace App\Modules\FactUnit\Application\List;

use App\Modules\FactUnit\Application\FactUnitResponse;
use App\Modules\FactUnit\Application\FactUnitResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactUnitListerQueryHandler implements QueryHandler
{
    public function __construct(private FactUnitLister $lister)
    {
    }

    public function __invoke(FactUnitListerQuery $query): FactUnitResponses
    {
        return new FactUnitResponses(...array_map(
            fn ($index) => new FactUnitResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
