<?php

namespace App\Modules\FactUnit\Application\Index;

use App\Modules\FactUnit\Application\Index\FactUnitIndexerResponse;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\FactUnit\Domain\FactUnitRepository;
use App\Modules\FactUnit\Domain\IndexFactUnit;

final class FactUnitIndexer
{
    public function __construct(private FactUnitRepository $repository)
    {
    }

    public function __invoke(IdFactUnit $idFactUnit)
    {
        $index = $this->repository->find(new IndexFactUnit($idFactUnit));
        return $index;
    }
}
