<?php

namespace App\Modules\FactTypeOperation\Application\Index;

use App\Modules\FactTypeOperation\Application\FactTypeOperationResponse;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeOperationIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeOperationIndexer $inserter)
    {
    }

    public function __invoke(FactTypeOperationIndexerQuery $query): FactTypeOperationResponse
    {
        $model = $this->inserter->__invoke(new IdFactTypeOperation($query->getId()));
        return new FactTypeOperationResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
