<?php

namespace App\Modules\FactTypeDocument\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactTypeDocument implements StorageCriteria
{

    public function __construct(private string $action) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactTypeDocument::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactTypeDocument_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactTypeDocument_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactTypeDocument_Status` = 0';
        } else {
            $where = '`ftd`.`FactTypeDocument_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_type_document` `ftd`
            WHERE $where",
            [ ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
