<?php

namespace App\Modules\FactTypeDocument\Application\List;

use App\Modules\FactTypeDocument\Application\FactTypeDocumentResponse;
use App\Modules\FactTypeDocument\Application\FactTypeDocumentResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeDocumentListerQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeDocumentLister $lister)
    {
    }

    public function __invoke(FactTypeDocumentListerQuery $query): FactTypeDocumentResponses
    {
        return new FactTypeDocumentResponses(...array_map(
            fn ($index) => new FactTypeDocumentResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
