<?php

namespace App\Modules\FactReceiptDetail\Application\List;

use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailRepository;
use App\Modules\FactReceiptDetail\Domain\ListFactReceiptDetail;

final class FactReceiptDetailLister
{
    public function __construct(private FactReceiptDetailRepository $repository)
    {
    }

    public function __invoke(IdFactReceipt $idFactReceipt, string $action)
    {
        return $this->repository->search(new ListFactReceiptDetail($idFactReceipt, $action));
    }
}
