<?php

namespace App\Modules\FactReceipt\Application\UpdateStatus;

use App\Modules\FactReceipt\Application\Index\FactReceiptIndexer;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptAddress;
use App\Modules\FactReceipt\Domain\FactReceiptBusinessName;
use App\Modules\FactReceipt\Domain\FactReceiptCurrency;
use App\Modules\FactReceipt\Domain\FactReceiptEmail;
use App\Modules\FactReceipt\Domain\FactReceiptLicensePlate;
use App\Modules\FactReceipt\Domain\FactReceiptNoDocument;
use App\Modules\FactReceipt\Domain\FactReceiptResponseMessage;
use App\Modules\FactReceipt\Domain\FactReceiptStatus;
use App\Modules\FactReceipt\Domain\UpdateFactReceipt;
use App\Modules\FactReceipt\Domain\UpdateStatusFactReceipt;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateStatusFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(
        private FactReceiptStatusUpdater $updater,
        private FactReceiptIndexer $indexer
    ) {
    }

    public function __invoke(UpdateStatusFactReceiptQuery $query)
    {
        $model = new UpdateStatusFactReceipt(
            new IdFactReceipt($query->id()),
            new FactReceiptResponseMessage($query->responseMessage()),
            new FactReceiptStatus($query->status()),
        );
        return new UpdateStatusFactReceiptResponse($this->updater->__invoke($model));
    }
}
