<?php

namespace App\Modules\FactReceipt\Application\Update;

use App\Modules\FactReceipt\Application\Update\FactReceiptUpdaterResponse;
use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptRepository;
use App\Modules\FactReceipt\Domain\UpdateFactReceipt;

final class FactReceiptUpdater
{
    public function __construct(private FactReceiptRepository $repository)
    {
    }

    public function __invoke(UpdateFactReceipt $lead): FactReceiptUpdaterResponse
    {
        return new FactReceiptUpdaterResponse($this->repository->update($lead));
    }
}
