<?php

namespace App\Modules\FactReceipt\Application\Index;

use App\Modules\FactReceipt\Application\FactReceiptResponse;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactReceiptIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptIndexer $inserter)
    {
    }

    public function __invoke(FactReceiptIndexerQuery $query): FactReceiptResponse
    {
        $model = $this->inserter->__invoke(new IdFactReceipt($query->getId()));
        return new FactReceiptResponse(
            $model->id()->value(),
            $model->date()->value(),
            $model->dateUpdate()->value(),
            $model->dateEmission()->value(),
            $model->noDocument()->value(),
            $model->businessName()->value(),
            $model->email()->value(),
            $model->address()->value(),
            $model->licensePlate()->value(),
            $model->currency()->value(),
            $model->responseMessage()->value(),
            $model->status()->value(),
            $model->idFactTypeReceipt()->value(),
            $model->idFactTypeDocument()->value(),
            $model->idFactPaymentMethod()->value(),
            $model->idFactCurrency()->value(),
        );
    }
}
