<?php

namespace App\Modules\FactReceipt\Application\Delete;

use App\Modules\FactReceipt\Application\Index\FactReceiptIndexer;
use App\Modules\FactReceipt\Application\Update\FactReceiptUpdater;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptAddress;
use App\Modules\FactReceipt\Domain\FactReceiptBusinessName;
use App\Modules\FactReceipt\Domain\FactReceiptCurrency;
use App\Modules\FactReceipt\Domain\FactReceiptDate;
use App\Modules\FactReceipt\Domain\FactReceiptDateEmission;
use App\Modules\FactReceipt\Domain\FactReceiptDateUpdate;
use App\Modules\FactReceipt\Domain\FactReceiptEmail;
use App\Modules\FactReceipt\Domain\FactReceiptLicensePlate;
use App\Modules\FactReceipt\Domain\FactReceiptNoDocument;
use App\Modules\FactReceipt\Domain\FactReceiptResponseMessage;
use App\Modules\FactReceipt\Domain\FactReceiptStatus;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(
        private FactReceiptDeleter $deleter
    ) {
    }

    public function __invoke(DeleteFactReceiptQuery $query): DeleteFactReceiptResponse
    {
        return new DeleteFactReceiptResponse($this->deleter->__invoke(new IdFactReceipt($query->id())));
    }
}
