<?php

namespace App\Modules\FactProduct\Application\Creator;

use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactProduct\Domain\FactProductRepository;

final class FactProductCreator
{
    public function __construct(private FactProductRepository $repository)
    {
    }

    public function __invoke(FactProduct $factProduct): CreateFactProductResponse
    {
        return new CreateFactProductResponse($this->repository->insert($factProduct));
    }
}
