<?php

namespace App\Modules\FactPaymentMethod\Application\Index;

use App\Modules\FactPaymentMethod\Application\FactPaymentMethodResponse;
use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexFactPaymentMethodQueryHandler implements QueryHandler
{
    public function __construct(private FactPaymentMethodIndexer $inserter)
    {
    }

    public function __invoke(IndexFactPaymentMethodQuery $query): FactPaymentMethodResponse
    {
        $model = $this->inserter->__invoke(new IdFactPaymentMethod($query->getId()));
        return new FactPaymentMethodResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
