<?php

namespace App\Modules\ExternalUserPassenger\Domain;

use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\Passenger\Domain\IdPassenger;

class ExternalUserPassenger
{

    /** constructor */
    public function __construct(
        private ExternalUserPassengerStatus $status,
        private IdExternalUser $idExternalUser,
        private IdPassenger $idPassenger,
        private ?IdExternalUserPassenger $id = null
    ) {
    }
    public function getStatus(): ExternalUserPassengerStatus
    {
        return $this->status;
    }
    public function getIdExternalUser(): IdExternalUser
    {
        return $this->idExternalUser;
    }
    public function getIdPassenger(): IdPassenger
    {
        return $this->idPassenger;
    }
    public function getId(): IdExternalUserPassenger
    {
        return $this->id;
    }
}
