<?php

namespace App\Modules\ExternalApiRequest\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateExternalApiRequestQuery implements Query
{
    public function __construct(
        private int $id,
        private string $response,
        private int $status,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function response(): string
    {
        return $this->response;
    }

    public function status(): int
    {
        return $this->status;
    }
}
