<?php

namespace App\Modules\CashMovementFactReceipt\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CashMovementFactReceiptUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private int $status,
        private int $idCashMovement,
        private int $idFactReceipt,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idCashMovement(): int
    {
        return $this->idCashMovement;
    }

    public function idFactReceipt(): int
    {
        return $this->idFactReceipt;
    }
}
