<?php

namespace App\Modules\CashMovementFactReceipt\Application\List;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;
use App\Modules\CashMovementFactReceipt\Domain\ListCashMovementFactReceipt;

final class CashMovementFactReceiptLister
{
    public function __construct(private CashMovementFactReceiptRepository $repository)
    {
    }

    public function __invoke(IdCashMovement $idCashMovement, string $action)
    {
        return $this->repository->search(new ListCashMovementFactReceipt($idCashMovement, $action));
    }
}
