<?php

namespace App\Modules\CashMovement\Application\Index;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovement\Domain\CashMovementRepository;

final class CashMovementIndexer
{
    public function __construct(private CashMovementRepository $repository)
    {
    }

    public function __invoke(IdCashMovement $idCashMovement): IndexCashMovementResponse
    {
        return new IndexCashMovementResponse($this->repository->index($idCashMovement));
    }
}
