<?php

namespace App\Modules\CashMovement\Application;

use App\Modules\CashMovement\Domain\CashMovementRedistributeRepository;
use App\Modules\CashMovement\Domain\RedistributeCashMovement;

class CashMovementRedistributor {

    private CashMovementRedistributeRepository $repository;

    public function __construct(
        CashMovementRedistributeRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(RedistributeCashMovement $model) {
        return $this->repository->redistribute($model);
    }
}