<?php

namespace App\Modules\Briefing\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class BriefingType extends EnumValueObject
{

    public const ALL = 'all';
    public const ONTIME = 'ontime';
    public const ADVANCED = 'advanced';
    
    public static function values(): array
    {
        return [ self::ONTIME, self::ADVANCED, self::ALL ];
    }

    public static function defaultValue()
    {
        return new self(self::ALL);
    }
}
